function [LogL,Rt,veclRt,LL]=TCopulaLogLikhood(theta,data,corrspec,optimizer,method)
% The neggative log-likelihood of the time varying T Copula.
% IMPUTS:
% theta:            Vector of parameters. 
% data:             matrix of U(0,1) or iid margins
% corrspec:         String with values 'DCC', 'TVC, or 'Patton'
% optimizer:        String with values 'fmincon' or 'fminunc'
% method:           String with values 'CML' or 'IFM'

% Warning:          If you want to estimate the parameters of your T
%                   Copula, you should run the function
%                   EstimateTVTCopula.m, which call this function
if nargin==4
    method='CML';
end
if nargin==3
    method='CML'; optimizer='fmincon';
end
if strcmp(corrspec,'fminunc')==1
nu=2+exp(theta(1));
else
nu=theta(1);
end

if min(min(data))<0.0000000000001 || max(max(data))>0.999999999999
if strcmp(method,'IFM')==1
   trdata=tinv(tcdf(data,nu),nu);
elseif strcmp(method,'CML')==1
    trdata=tinv(empiricalCDF(data),nu);
end
else
    trdata=tinv(data,nu);
end
[T,N]=size(data);
if strcmp(optimizer,'fmincon')==1
if strcmp(corrspec,'DCC')==1 
    [Rt, veclRt]=DCCeq(theta(2:end),trdata);
elseif strcmp(corrspec,'TVC')==1
    [Rt, veclRt]=TVCeq(theta(2:end),trdata);
elseif strcmp(corrspec,'Patton')==1 && N==2
    [Rt, veclRt]=Pattoneq(theta(2:end),data);
elseif strcmp(corrspec,'Patton')==1 && N>2
    display('Patton eq is for bivariate data only. DCC is loaded')
    [Rt, veclRt]=DCCeq(theta(2:end),trdata);
end
elseif strcmp(optimizer,'fminunc')==1
if strcmp(corrspec,'DCC')==1 
    [Rt, veclRt]=DCCeq(theta(2:end),trdata,optimizer);
elseif strcmp(corrspec,'TVC')==1
    [Rt, veclRt]=TVCeq(theta(2:end),trdata,optimizer);
elseif strcmp(corrspec,'Patton')==1 && N==2
    [Rt, veclRt]=Pattoneq(theta(2:end),data);
elseif strcmp(corrspec,'Patton')==1 && N>2
    display('Patton eq is for bivariate data only. DCC is loaded')
    [Rt, veclRt]=DCCeq(theta(2:end),trdata,optimizer);
end  
end
% The T Copula likelihood function 
    LL=zeros(T,1); 
    for i=1:T
        LL(i) = gammaln((nu+N)/2) + (N-1)*gammaln(nu/2) - N*gammaln((nu+1)/2) - 0.5*log(det(Rt(:,:,i)));
        LL(i) = LL(i) - (nu+N)/2*log(1+trdata(i,:)*inv(Rt(:,:,i))*trdata(i,:)'./nu);
        LL(i) = LL(i) + (nu+1)/2*sum(log(1+(trdata(i,:).^2/nu)));
    end
    likelihood=sum(LL);
    LogL=-likelihood;
    LL=-LL;  %indivdual negative likelihood for score computation
